local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");
local PulseLabel = THEME:GetMetric("Combo", "PulseLabelCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local LabelMinZoom = THEME:GetMetric("Combo", "LabelMinZoom");
local LabelMaxZoom = THEME:GetMetric("Combo", "LabelMaxZoom");

local t = Def.ActorFrame {
	InitCommand=cmd(vertalign,bottom);
	LoadFont("Combo numbers") .. {
		Name="Number";
		OnCommand=THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor(THEME:GetPathG("_label","combo"))..{
		Name="Combo";
		OnCommand=THEME:GetMetric("Combo", "LabelOnCommand");
	};
	LoadActor(THEME:GetPathG("_label","miss"))..{
		Name="Misses";
		OnCommand=THEME:GetMetric("Combo", "LabelOnCommand");
	};

	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
		c.Combo:visible(false);
		c.Misses:visible(false);
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			c.Combo:visible(false);
			c.Misses:visible(false);
			return;
		end

		local label = param.Misses and c.Misses or c.Combo
		local other = param.Misses and c.Combo or c.Misses

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );
		
		c.Number:visible(true);
		c.Number:settext( string.format("%i", iCombo) );

		label:visible(true)
		other:visible(false)

		-- FullCombo Rewards
		if param.FullComboW1 then
			c.Number:diffuse(color("#00aeef"));
			c.Number:glowshift();
			label:diffuse(color("#00aeef"));
			label:glowshift();
		elseif param.FullComboW2 then
			c.Number:diffuse(color("#fff568"));
			c.Number:glowshift();
			label:diffuse(color("#fff568"));
			label:glowshift();
		elseif param.FullComboW3 then
			c.Number:diffuse(color("#a4ff00"));
			c.Number:stopeffect();
			label:diffuse(color("#a4ff00"));
			label:stopeffect();
		elseif param.Combo then
			c.Number:diffuse(color("#FFFFFF"));
			c.Number:stopeffect();
			label:diffuse(color("#FFFFFF"));
			label:stopeffect();
		else
			c.Number:diffuse(color("#ff0000"));
			c.Number:stopeffect();
			label:diffuse(color("#ff0000"));
			label:stopeffect();
		end
		-- Pulse
		Pulse( c.Number, param );
		Pulse( c.Combo, param );
		Pulse( c.Misses, param );
	end;
};

return t;
